/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.tree;

import icyllis.arc3d.compiler.Context;
import icyllis.arc3d.compiler.Position;
import icyllis.arc3d.compiler.tree.Node;
import icyllis.arc3d.compiler.tree.Type;
import java.util.OptionalDouble;
import javax.annotation.Nonnull;

public abstract class Expression
extends Node {
    private final Type mType;

    protected Expression(int position, Type type) {
        super(position);
        this.mType = type;
    }

    public abstract Node.ExpressionKind getKind();

    @Nonnull
    public Type getType() {
        assert (this.mType != null);
        return this.mType;
    }

    public boolean isConstructorCall() {
        return false;
    }

    public boolean isLiteral() {
        return false;
    }

    public final boolean isIntLiteral() {
        return this.isLiteral() && this.getType().isInteger();
    }

    public final boolean isFloatLiteral() {
        return this.isLiteral() && this.getType().isFloat();
    }

    public final boolean isBooleanLiteral() {
        return this.isLiteral() && this.getType().isBoolean();
    }

    public final long getCoercionCost(Type other) {
        if (this.isIntLiteral() && other.isNumeric()) {
            return Type.CoercionCost.free();
        }
        return this.getType().getCoercionCost(other);
    }

    public final boolean isIncomplete(@Nonnull Context context) {
        return switch (this.getKind()) {
            case Node.ExpressionKind.FUNCTION_REFERENCE -> {
                int pos = this.getEndOffset();
                pos = Position.range(pos, pos + 1);
                context.error(pos, "expected '(' to begin function invocation");
                yield true;
            }
            case Node.ExpressionKind.TYPE_REFERENCE -> {
                int pos = this.getEndOffset();
                pos = Position.range(pos, pos + 1);
                context.error(pos, "expected '(' to begin constructor invocation");
                yield true;
            }
            default -> false;
        };
    }

    public OptionalDouble getConstantValue(int i) {
        return OptionalDouble.empty();
    }

    @Nonnull
    public final Expression clone() {
        return this.clone(this.mPosition);
    }

    @Nonnull
    public abstract Expression clone(int var1);

    @Override
    @Nonnull
    public final String toString() {
        return this.toString(17);
    }

    @Nonnull
    public abstract String toString(int var1);
}

